#!/usr/bin/env python

import sys, os
import imaplib
import getpass

#
# IMAP account settings
#
imap_server = 'imapserver.com'
account = "user@imapserver.com"
out_dir = '/path/to/the/email-output'

#
# Export Emails
#
passwd = getpass.getpass()

def process_mailbox(M,finaloutput):
    """
    Dump all emails in the folder to files in output directory.
    """

    rv, data = M.search(None, "ALL")
    if rv != 'OK':
        print "No messages found!"
        return
    for num in data[0].split():
        rv, data = M.fetch(num, '(RFC822)')
        if rv != 'OK':
            print "ERROR getting message", num
            return
        print "Writing message ", num
        directory = '%s/%s' %(out_dir, finaloutput)
        if not os.path.exists(directory):
            os.makedirs(directory)
        f = open('%s/%s/%s.eml' %(out_dir, finaloutput, num), 'wb')
        f.write(data[0][1])
        f.close()

def main():
    M = imaplib.IMAP4_SSL(imap_server)
    M.login(account, passwd)
    boxes = M.list()
    for box in boxes[1]:
        if '"." ' in box:
            dross, folder = box.split('"." ',1)
            output = folder.replace(" ", "_")
            finaloutput = output.replace("\"", "")
            rv, data = M.select(finaloutput)
            if rv == 'OK':
                print "Processing mailbox: ", finaloutput
                process_mailbox(M,finaloutput)
                M.close()
        else:
            print "ERROR: Unable to open mailbox ", rv
    M.logout()

if __name__ == "__main__":
    main()
